    clear all;
    close all;

%File details
    delimiterIn = ',';
    headerLinesIn = 0;

    if(exist('PathName','var')==0); PathName = ''; end
    
    %r=[0:0.1:16] 
    %y = zeros(length(r),1);
    figure;
    hold on;
    %plot(r,y,'--k');
    
    
    n = 7;
    for i = 1:n
   
%Open the datafile
    FilterSpec = '.dat';

    DialogTitle = 'Select file with H/R data.';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata([PathName,posH_Datafile],delimiterIn,headerLinesIn);
   
%Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data=imp_Data.data;
    else Data = imp_Data; end
       
%Plot Data    
    R0 = Data(1,2);
    Data(:,1) = Data(:,1)./R0;
    Data(:,2) = Data(:,2)./R0;
    plot(Data(:,1),Data(:,2));
    
    
    end
    
    
    xlabel('B/R(0) (T \Omega^{-1})','fontsize',18,'fontname','times');
    ylabel('R(B)/(R(0)','fontsize',19,'fontname','times');   
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w'); 
    set(findall(gca, 'Type', 'Line'),'LineWidth',2);
    set(gcf, 'Position', [50, 50, 600, 550])
    set(gca,'fontsize',18,'fontname','times');
    box on;
    legend('10 K', '20 K', '30 K', '45 K', '60 K', '75 K', '90 K');
    legend boxoff;
    hold off;
        
    